<script>
    $(document).ready(function() {
        $('.summernote').summernote({
            height: 350,                 // set editor height

            minHeight: 350,             // set minimum height of editor
            maxHeight: 350,             // set maximum height of editor

            focus: true                 // set focus to editable area after initializing summernote
        });
    });
</script>
<div class="container">
    <div class="row">
        <div class="form-group col-md-12" style="margin-top:20px;">
            <ol class="breadcrumb">
                <li><a href="<?php echo base_url()?>administrator/home"><i class="glyphicon glyphicon-home"></i> Home</a></li>
                <li><a href="<?php echo base_url()?>administrator/product_category">Product Category</a></li>
                <li class="active">Product Category Form</li>
            </ol>
        </div>
        <div class="form-group col-md-12">
            <h3>Product Category Form</h3>
        </div>
        <div class="form-group col-md-12">
            <?php
            if(!empty($error)){
                echo "<div class='alert alert-danger'>".$error."</div>";
            }
            ?>
        </div>
        <form name="uploadform" method="POST" enctype="multipart/form-data" >
            <div class="form-group col-md-12">
                <div class="col-md-3 control-label">Title</div>
                <div class="col-md-9">
                    <input type="hidden" id="id" name="id" value="<?php echo $id; ?>"/>
                    <input type="hidden" id="depth" name="depth" value="<?php echo $depth; ?>"/>
                    <input type="text" id="title" name="title" class="form-control" value="<?php echo $title; ?>"/>
                </div>
            </div>
            <div class="form-group col-md-12">
                <div class="col-md-3 control-label">Parent Category</div>
                <div class="col-md-9">
                    <select id="parent_id" name="parent_id" class="form-control">
                        <option value="0" <?php echo $parent_id===0?"selected":"";?>>None</option>
                        <?php
                        foreach($product_category as $key=>$value){
                        ?>
                        <option value="<?php echo $value->id;?>" <?php echo $parent_id===$value->id?"selected":"";?>><?php echo $value->title;?></option>
                        <?php
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="form-group col-md-12">
                <div class="col-md-3 control-label">Image</div>
                <div class="col-md-9">
                    <input type="file" id="image" name="image" class="form-control" accept="image/*"/>
                    <?php
                    if(!empty($image)){
                    ?>
                    <img src="<?php echo base_url().$image; ?>" class="img-thumbnail"/>
                    <?php
                    }
                    ?>
                </div>
            </div>
            <div class="form-group col-md-12">
                <div class="col-md-3">Summary</div>
                <div class="col-md-9">
                    <textarea id="summary" name="summary" class="summernote"><?php echo $summary;?></textarea>
                </div>
            </div>
            <div class="form-group col-md-12">
                <div class="col-md-3 control-label"> Status</div>
                <div class="col-md-9">
                    <select id="status" name="status" class="form-control">
                        <option value="0" <?php echo $status?"":"selected";?>>Hidden</option>
                        <option value="1" <?php echo $status?"selected":"";?>>Published</option>
                    </select>
                </div>
            </div>
            <div class="form-group col-md-12" align="center">
                <input type="submit" id="submit" name="submit" class="btn btn-success" value="Submit">
                &nbsp;
                <input type="reset" id="reset" name="reset" class="btn btn-warning" value="Reset">
                &nbsp;
                <a href="<?php echo base_url().'administrator/product_category'?>" class="btn btn-default">Cancel</a>
            </div>
        </form>
    </div>
</div>
<script>