<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
  
class product_model extends CI_Model {
 
    function __construct() {
        parent::__construct();
        $this->load->database();
    }
 
    function find($where='', $limit='10', $offset='', $q='') {
        $this->db->select('product.*,product_category.title as product_category_title');
        $this->db->from('product');
        $this->db->join('product_category', 'product.product_category_id = product_category.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('product');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword['product.'.$field] = $q;
            }
            $keyword['product_category.title'] = $q;
            $this->db->or_like($keyword);
        }
        $order = 'product.id asc';
        $this->db->order_by($order);
      
        if(!empty($offset) && !empty($limit)){
            $this->db->limit($limit, $offset);
        }
        elseif(!empty($limit)){
            $this->db->limit($limit);
        }
        
        $query =  $this->db -> get();
        
        return $query;
    }
    
    public function add($data)
    {		
            $result = $this->db->insert('product', $data); 
            return $result;
    }
    
    public function edit($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('product', $data); 

            return $result;
    }
    
    public function replace($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('product', $data); 
            return $result;
    }
    
    public function delete($where)
    {		
            $this->db->where($where);
            $result = $this->db->delete('product'); 
            
            return $result;
    }
    
    public function getTotalRows($where='', $limit='10', $offset='', $q=''){
        
        $this->db->select('product.*,product_category.title as product_category_title');
        $this->db->from('product');
        $this->db->join('product_category', 'product.product_category_id = product_category.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('product');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword['product.'.$field] = $q;
            }
            $keyword['product_category.title'] = $q;
            $this->db->or_like($keyword);
        }
        $order = 'product.id asc';
        $this->db->order_by($order);
        
        $query =  $this->db -> get()->num_rows();
        
        return $query;
    }
    
    public function affectedRows(){
        return $this->db->affected_rows();
    }
    
    public function getErrorMessage(){
        return $this->db->_error_message();
    }
}