<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
  
class training_model extends CI_Model {
 
    function __construct() {
        parent::__construct();
        $this->load->database();
    }
 
    function find($where='', $limit='10', $offset='', $q='') {
        $this->db->select('training.*,training_category.title as training_category_title');
        $this->db->from('training');
        $this->db->join('training_category', 'training.training_category_id = training_category.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('training');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword['training.'.$field] = $q;
            }
            $keyword['training_category.title'] = $q;
            $this->db->or_like($keyword);
        }
        $order = 'training.id asc';
        $this->db->order_by($order);
      
        if(!empty($offset) && !empty($limit)){
            $this->db->limit($limit, $offset);
        }
        elseif(!empty($limit)){
            $this->db->limit($limit);
        }
        
        $query =  $this->db -> get();
        
        return $query;
    }
    
    public function add($data)
    {		
            $result = $this->db->insert('training', $data); 
            return $result;
    }
    
    public function edit($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('training', $data); 

            return $result;
    }
    
    public function replace($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('training', $data); 
            return $result;
    }
    
    public function delete($where)
    {		
            $this->db->where($where);
            $result = $this->db->delete('training'); 
            
            return $result;
    }
    
    public function getTotalRows($where='', $limit='10', $offset='', $q=''){
        
        $this->db->select('training.*,training_category.title as training_category_title');
        $this->db->from('training');
        $this->db->join('training_category', 'training.training_category_id = training_category.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('training');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword['training.'.$field] = $q;
            }
            $keyword['training_category.title'] = $q;
            $this->db->or_like($keyword);
        }
        $order = 'training.id asc';
        $this->db->order_by($order);
        
        $query =  $this->db -> get()->num_rows();
        
        return $query;
    }
    
    public function affectedRows(){
        return $this->db->affected_rows();
    }
    
    public function getErrorMessage(){
        return $this->db->_error_message();
    }
}