<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
  
class consulting_service_model extends CI_Model {
 
    function __construct() {
        parent::__construct();
        $this->load->database();
    }
 
    function find($where='', $limit='10', $offset='', $q='') {
        $this->db->select('consulting_service.*,consulting_service_category.title as consulting_service_category_title');
        $this->db->from('consulting_service');
        $this->db->join('consulting_service_category', 'consulting_service.consulting_service_category_id = consulting_service_category.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('consulting_service');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword['consulting_service.'.$field] = $q;
            }
            $keyword['consulting_service_category.title'] = $q;
            $this->db->or_like($keyword);
        }
        $order = 'consulting_service.id asc';
        $this->db->order_by($order);
      
        if(!empty($offset) && !empty($limit)){
            $this->db->limit($limit, $offset);
        }
        elseif(!empty($limit)){
            $this->db->limit($limit);
        }
        
        $query =  $this->db -> get();
        
        return $query;
    }
    
    public function add($data)
    {		
            $result = $this->db->insert('consulting_service', $data); 
            return $result;
    }
    
    public function edit($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('consulting_service', $data); 

            return $result;
    }
    
    public function replace($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('consulting_service', $data); 
            return $result;
    }
    
    public function delete($where)
    {		
            $this->db->where($where);
            $result = $this->db->delete('consulting_service'); 
            
            return $result;
    }
    
    public function getTotalRows($where='', $limit='10', $offset='', $q=''){
        
        $this->db->select('consulting_service.*,consulting_service_category.title as consulting_service_category_title');
        $this->db->from('consulting_service');
        $this->db->join('consulting_service_category', 'consulting_service.consulting_service_category_id = consulting_service_category.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('consulting_service');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword['consulting_service.'.$field] = $q;
            }
            $keyword['consulting_service_category.title'] = $q;
            $this->db->or_like($keyword);
        }
        $order = 'consulting_service.id asc';
        $this->db->order_by($order);
        
        $query =  $this->db -> get()->num_rows();
        
        return $query;
    }
    
    public function affectedRows(){
        return $this->db->affected_rows();
    }
    
    public function getErrorMessage(){
        return $this->db->_error_message();
    }
}