<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class software_controller extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('backend/software_category_model');
        $this->load->model('backend/software_model');
        $this->load->helper(array('form','url'));
        $this->load->library(array('form_validation','session'));
        $this->load->library("pagination");
    }
    
    function uploadFile($path, $file_type, $file_max_size, $overwrite, $file_max_width, $file_max_height, $file){
        
        $config['upload_path'] = $path;
        $config['allowed_types'] = $file_type;
        $config['max_size'] = $file_max_size;
        $config['overwrite'] = $overwrite;
        $config['max_width'] = $file_max_width;
        $config['max_height'] = $file_max_height;

        $this->load->library('upload', $config);
        if ( ! $this->upload->do_upload($file))
        {
            $result = array(false, $this->upload->display_errors());
            return $result;
        }
        else
        {
            $result = array(true, $this->upload->data());
            return $result;
        }
    }
 
    function index($page=""){
        if($this->session->userdata('logged_in'))
        {
            $q = "";
            if($this->input->post()){
                $post_data = $this->input->post();
                $q = $post_data['search'];
            }
            
            $page_limit = '20';
            
            $data['error'] = "";
            $where = array();
            $query = $this->software_model->find($where="", $limit="", $offset="", $q);
            $config['base_url'] = base_url().'/administrator/software/';
            $config['total_rows'] = $query->num_rows;
            $config['per_page'] = $page_limit; 
            $config['use_page_numbers']  = TRUE;
            $config['first_tag_open'] = $config['last_tag_open']= $config['next_tag_open']= $config['prev_tag_open'] = $config['num_tag_open'] = '<li>';
            $config['first_tag_close'] = $config['last_tag_close']= $config['next_tag_close']= $config['prev_tag_close'] = $config['num_tag_close'] = '</li>';
            $config['cur_tag_open'] = "<li class='active'><span>";
            $config['cur_tag_close'] = "</span></li>";
            $this->pagination->initialize($config); 

            $data['paging'] = $this->pagination->create_links();
            
            if($page){
                $offset = ($page-1) * $page_limit;
            }
            else{
                $offset = 0;
            }
            
            $query = $this->find($where="", $limit="20", $offset, $q);
            if($query->num_rows() > 0){
                $data['software'] = $query->result();
            }
            else{
                $data['software'] = "";
            }
            
            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/software', $data);
            $this->load->view('backend/footer');
            
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function create(){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            $data = array('id'=>'','title'=>'','description'=>'','software_category_id'=>'','status'=>'1');
            
            $where = "";
            $where = array('a.status'=>'1');
            $query = $this->software_category_model->find($where, $limit="", $offset="", $q="");
            if($query->num_rows() > 0){
                $data['software_category'] = $query->result();
            }
            else{
                $data['software_category'] = "";
            }
            
            if($this->input->post()){
                $post = $this->input->post();
                
                foreach($post as $key => $value){
                    if($key != "submit"){
                        $post_data[$key] = $value; 
                    }
                }
                $result = "";
                $result = $this->add($post_data);
                if($result){
                    redirect('administrator/software', 'refresh');
                }
                else{
                    $data['error'] = $this->software_category_model->getErrorMessage();
                } 
            }
            
            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/software_form',$data);
            $this->load->view('backend/footer');
        }
        else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function modify($id){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            
            if($this->input->post()){
                
                $where = array();
                $where['id'] = $id;
                $post = $this->input->post();
                $post_data = array();
                $post_data2 = array();
                foreach($post as $key => $value){
                    if($key != "submit"){
                        $post_data[$key] = $value; 
                    }
                }
                $result = $this->edit($where,$post_data);

                if($result){
                    redirect('administrator/software', 'refresh');
                }
                else{
                    $data['error'] = $this->software_model->getErrorMessage();
                }  
            }
            
            
            $where = "";
            $where['software.id'] = $id;
            $find = $this->software_model->find($where);
            $raw_data = $find->result();
            if($raw_data){
                foreach($raw_data as $key => $value){
                    foreach($value as $k => $v){
                        $data[$k] = $v;
                    }
                }
            }
            
            $where = "";
            $where = array('a.status'=>'1');
            $query = $this->software_category_model->find($where, $limit="", $offset="", $q="");
            if($query->num_rows() > 0){
                $data['software_category'] = $query->result();
            }
            else{
                $data['software_category'] = "";
            }
            

            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/software_form', $data);
            $this->load->view('backend/footer');
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function remove($id){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            $where = "";
            $where['software.id'] = $id;

            $search = $this->find($where);
            if ($search->num_rows() > 0) {
                $where = "";
                $where['id'] = $id;
                $remove = $this->delete($where);
                if($remove){
                    redirect('administrator/software', 'refresh');
                }
                else{
                    $data['error'] = $this->software_model->getErrorMessage();
                }
            }
            else{
                $data['error'] = $this->software_model->getErrorMessage();
            }

            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/software', $data);
            $this->load->view('backend/footer');
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function find($where="", $limit="",$offset="", $q=""){
        $query = $this->software_model->find($where,$limit,$offset,$q);
        return $query;
    }
    
    function add($post_data){
        $query = $this->software_model->add($post_data);
        return $query;
    }
    
    function edit($where,$post_data){
        $query = $this->software_model->edit($where,$post_data);
        return $query;
    }
    
    function delete($where){
        $query = $this->software_model->delete($where);
        return $query;
    }
}