<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class news_controller extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('backend/news_model');
        $this->load->model('backend/news_category_model');
        $this->load->helper(array('form','url'));
        $this->load->library(array('form_validation','session'));
        $this->load->library("pagination");
    }
    
    function uploadFile($path, $file_type, $file_max_size, $overwrite, $file_max_width, $file_max_height, $file){
        
        $config['upload_path'] = $path;
        $config['allowed_types'] = $file_type;
        $config['max_size'] = $file_max_size;
        $config['overwrite'] = $overwrite;
        $config['max_width'] = $file_max_width;
        $config['max_height'] = $file_max_height;

        $this->load->library('upload', $config);
        if ( ! $this->upload->do_upload($file))
        {
            $result = array(false, $this->upload->display_errors());
            return $result;
        }
        else
        {
            $result = array(true, $this->upload->data());
            return $result;
        }
    }
 
    function index($page=""){
        if($this->session->userdata('logged_in'))
        {
            $q = "";
            if($this->input->post()){
                $post_data = $this->input->post();
                $q = $post_data['search'];
            }
            
            $page_limit = '20';
            
            $data['error'] = "";
            $where = array();
            $query = $this->news_model->find($where="", $limit="", $offset="", $q);
            $config['base_url'] = base_url().'/administrator/news/';
            $config['total_rows'] = $query->num_rows;
            $config['per_page'] = $page_limit; 
            $config['use_page_numbers']  = TRUE;
            $config['first_tag_open'] = $config['last_tag_open']= $config['next_tag_open']= $config['prev_tag_open'] = $config['num_tag_open'] = '<li>';
            $config['first_tag_close'] = $config['last_tag_close']= $config['next_tag_close']= $config['prev_tag_close'] = $config['num_tag_close'] = '</li>';
            $config['cur_tag_open'] = "<li class='active'><span>";
            $config['cur_tag_close'] = "</span></li>";
            $this->pagination->initialize($config); 

            $data['paging'] = $this->pagination->create_links();
            
            if($page){
                $offset = ($page-1) * $page_limit;
            }
            else{
                $offset = 0;
            }
            
            $query = $this->find($where="", $limit="20", $offset, $q);
            if($query->num_rows() > 0){
                $data['news'] = $query->result();
            }
            else{
                $data['news'] = "";
            }
            
            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/news', $data);
            $this->load->view('backend/footer');
            
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function create(){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            $data = array('id'=>'','news_category_id'=>'','title'=>'','image'=>'','summary'=>'','description'=>'','created_date'=>date("Y-m-d"),'status'=>'1');
            
            $where = "";
            $where = array('status'=>'1');
            $query = $this->news_category_model->find($where, $limit="", $offset="", $q="");
            if($query->num_rows() > 0){
                $data['news_category'] = $query->result();
            }
            else{
                $data['news_category'] = "";
            }
            
            if($this->input->post()){
                $post = $this->input->post();
                $upload = $this->uploadFile('assets/img/news/', 
                                        'gif|jpg|png', 
                                        '100000', 
                                        'false', 
                                        '1024', 
                                        '768', 
                                        'image');
                if ($upload[0] == false)
                {
                    $data['error'] = $upload[1];
                    $post = $this->input->post();
                    foreach($post as $key => $value){
                        if($key != "submit"){
                            $data[$key] = $value; 
                        }
                    }
                }
                elseif ($upload[0] == true)
                {
                    $result = $upload[1];
                    foreach($post as $key => $value){
                        if($key != "submit" && $key!="image"){
                            $post_data[$key] = $value; 
                        }
                        elseif($key == 'image'){
                            $post_data['image'] = $value;
                        }
                    }
                    $post_data['image'] = 'assets/img/news/'.$result['file_name'];
                    $result = "";
                    $result = $this->add($post_data);
                    if($result){
                        redirect('administrator/news', 'refresh');
                    }
                    else{
                        $data['error'] = $this->news_model->getErrorMessage();
                    } 
                }
            }
            
            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/news_form',$data);
            $this->load->view('backend/footer');
        }
        else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function modify($id){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            
            $where = "";
            $where['news.id'] = $id;
            
            if($this->input->post()){
                if(!empty($_FILES['image']['name'])){
                    $upload = $this->uploadFile('assets/img/news/', 
                                                'gif|jpg|png', 
                                                '100000', 
                                                'false', 
                                                '1024', 
                                                '768', 
                                                'image');

                    if ($upload[0] == false)
                    {
                            $data['error'] = $upload[1];
                            $post = $this->input->post();
                            foreach($post as $key => $value){
                            if($key != "submit"){
                                $data[$key] = $value; 
                            }
                        }
                    }
                    elseif ($upload[0] == true)
                    {
                        $result = $upload[1];
                        
                        $where = array();
                        $where['id'] = $id;
                        $post = $this->input->post();
                        $post_data = array();
                        foreach($post as $key => $value){
                            if($key != "submit" && $key!="image"){
                                $post_data[$key] = $value; 
                            }
                            elseif($key == 'image'){
                                $post_data['image'] = $value;
                            }
                        }
                        
                        $post_data['image'] = 'assets/img/news/'.$result['file_name'];
                        $result = "";
                        $result = $this->edit($where,$post_data);

                        if($result){
                            redirect('administrator/news', 'refresh');
                        }
                        else{
                            $data['error'] = $this->news_model->getErrorMessage();
                        }  
                    }
                }
                else{
                    
                    $where = array();
                    $where['id'] = $id;
                    $post = $this->input->post();
                    $post_data = array();
                    $post_data2 = array();
                    foreach($post as $key => $value){
                        if($key != "submit" && $key != 'image'){
                            $post_data[$key] = $value; 
                        }
                        elseif($key == 'image'){
                            $post_data['image'] = $value;
                        }
                    }
                    $result = $this->edit($where,$post_data);

                    if($result){
                        redirect('administrator/news', 'refresh');
                    }
                    else{
                        $data['error'] = $this->news_model->getErrorMessage();
                    }  
                    
                }
            }

            $find = $this->news_model->find($where);
            $raw_data = $find->result();
            if($raw_data){
                foreach($raw_data as $key => $value){
                    foreach($value as $k => $v){
                        $data[$k] = $v;
                    }
                }
            }
            
            $where = "";
            $where = array('status'=>'1');
            $query = $this->news_category_model->find($where, $limit="", $offset="", $q="");
            if($query->num_rows() > 0){
                $data['news_category'] = $query->result();
            }
            else{
                $data['news_category'] = "";
            }
            
            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/news_form', $data);
            $this->load->view('backend/footer');
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function remove($id){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            $where = "";
            $where['news.id'] = $id;

            $search = $this->find($where);
            if ($search->num_rows() > 0) {
                $where = "";
                $where['news.id'] = $id;
                $remove = $this->delete($where);
                if($remove){
                    redirect('administrator/news', 'refresh');
                }
                else{
                    $data['error'] = $this->news_model->getErrorMessage();
                }
            }
            else{
                $data['error'] = $this->news_model->getErrorMessage();
            }

            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/news', $data);
            $this->load->view('backend/footer');
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function find($where="", $limit="",$offset="", $q=""){
        $query = $this->news_model->find($where,$limit,$offset,$q);
        return $query;
    }
    
    function add($post_data){
        $query = $this->news_model->add($post_data);
        return $query;
    }
    
    function edit($where,$post_data){
        $query = $this->news_model->edit($where,$post_data);
        return $query;
    }
    
    function delete($where){
        $query = $this->news_model->delete($where);
        return $query;
    }
}