<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
session_start(); //we need to call PHP's session object to access it through CI
class contacts_controller extends CI_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->model('backend/contacts_model');
        $this->load->helper(array('form', 'url','html'));
        $this->load->library(array('form_validation','session'));
    }
    
    public function index()
    {
        if($this->session->userdata('logged_in'))
        {
            $contacts['error'] = '';
            $contacts['success'] = '';

            //update
            if($this->input->post()){
                $post = $this->input->post();
                foreach($post as $key => $value){
                    if($key != "submit"){
                        $post_data[$key] = $value; 
                    }
                }
                $where = array();
                $where['id'] = '1';
                $result = $this->contacts_model->edit($where,$post_data);

                if($result){
                    $contacts['success'] = 'The contacts successfully updated.';
                }
                else{
                    $contacts['error'] = $this->contacts_model->getErrorMessage();
                }  
            }

            $where = array();
            $where['id'] = '1';
            $result = $this->contacts_model->find($where)->result();
            $contacts['result'] = $result[0];



            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/contacts',$contacts);
            $this->load->view('backend/footer');
        }
        else{
            //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */