<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/
//frontpage
$route['default_controller'] = "frontend/index_controller/index";
$route['about_us'] = "frontend/index_controller/about";
$route['history'] = "frontend/index_controller/history";
$route['software_products'] = "frontend/index_controller/software_products";
$route['software/view/(:num)'] = "frontend/index_controller/software/$1";
$route['products/view/(:num)'] = "frontend/index_controller/products/$1";
$route['consulting_service'] = "frontend/index_controller/consulting_service";
$route['training'] = "frontend/index_controller/training";
$route['clients'] = "frontend/index_controller/clients";
$route['news/(:num)/list'] = "frontend/index_controller/news/$1";
$route['news/(:num)/list/(:num)'] = "frontend/index_controller/news/$1/$2";
$route['news/(:num)/view/(:num)'] = "frontend/index_controller/news_view/$1/$2";
//$route['news/list'] = "frontend/index_controller/news";
//$route['news/list/(:num)'] = "frontend/index_controller/news/$1";
//$route['news/view/(:num)'] = "frontend/index_controller/news_view/$1";
$route['contacts'] = "frontend/index_controller/contacts";


//administrator
$route['administrator'] = "backend/login_controller";
$route['administrator/login'] = "backend/login_controller";
$route['administrator/home'] = "backend/home_controller";
$route['administrator/change_password'] = "backend/user_controller";
$route['administrator/logout'] = "backend/home_controller/logout";

$route['administrator/contacts'] = "backend/contacts_controller";
$route['administrator/about'] = "backend/about_controller";

$route['administrator/news_category'] = "backend/news_category_controller";
$route['administrator/news_category/(:num)'] = "backend/news_category_controller/index/$1";
$route['administrator/news_category/new'] = "backend/news_category_controller/create";
$route['administrator/news_category/edit/(:num)'] = "backend/news_category_controller/modify/$1";
$route['administrator/news_category/delete/(:num)'] = "backend/news_category_controller/remove/$1";

$route['administrator/news'] = "backend/news_controller";
$route['administrator/news/(:num)'] = "backend/news_controller/index/$1";
$route['administrator/news/new'] = "backend/news_controller/create";
$route['administrator/news/edit/(:num)'] = "backend/news_controller/modify/$1";
$route['administrator/news/delete/(:num)'] = "backend/news_controller/remove/$1";

$route['administrator/software_category'] = "backend/software_category_controller";
$route['administrator/software_category/(:num)'] = "backend/software_category_controller/index/$1";
$route['administrator/software_category/new'] = "backend/software_category_controller/create";
$route['administrator/software_category/edit/(:num)'] = "backend/software_category_controller/modify/$1";
$route['administrator/software_category/delete/(:num)'] = "backend/software_category_controller/remove/$1";

$route['administrator/software'] = "backend/software_controller";
$route['administrator/software/(:num)'] = "backend/software_controller/index/$1";
$route['administrator/software/new'] = "backend/software_controller/create";
$route['administrator/software/edit/(:num)'] = "backend/software_controller/modify/$1";
$route['administrator/software/delete/(:num)'] = "backend/software_controller/remove/$1";

$route['administrator/product_category'] = "backend/product_category_controller";
$route['administrator/product_category/(:num)'] = "backend/product_category_controller/index/$1";
$route['administrator/product_category/new'] = "backend/product_category_controller/create";
$route['administrator/product_category/edit/(:num)'] = "backend/product_category_controller/modify/$1";
$route['administrator/product_category/delete/(:num)'] = "backend/product_category_controller/remove/$1";

$route['administrator/product'] = "backend/product_controller";
$route['administrator/product/(:num)'] = "backend/product_controller/index/$1";
$route['administrator/product/new'] = "backend/product_controller/create";
$route['administrator/product/edit/(:num)'] = "backend/product_controller/modify/$1";
$route['administrator/product/delete/(:num)'] = "backend/product_controller/remove/$1";

$route['administrator/consulting_service_category'] = "backend/consulting_service_category_controller";
$route['administrator/consulting_service_category/(:num)'] = "backend/consulting_service_category_controller/index/$1";
$route['administrator/consulting_service_category/new'] = "backend/consulting_service_category_controller/create";
$route['administrator/consulting_service_category/edit/(:num)'] = "backend/consulting_service_category_controller/modify/$1";
$route['administrator/consulting_service_category/delete/(:num)'] = "backend/consulting_service_category_controller/remove/$1";

$route['administrator/consulting_service'] = "backend/consulting_service_controller";
$route['administrator/consulting_service/(:num)'] = "backend/consulting_service_controller/index/$1";
$route['administrator/consulting_service/new'] = "backend/consulting_service_controller/create";
$route['administrator/consulting_service/edit/(:num)'] = "backend/consulting_service_controller/modify/$1";
$route['administrator/consulting_service/delete/(:num)'] = "backend/consulting_service_controller/remove/$1";

$route['administrator/training_category'] = "backend/training_category_controller";
$route['administrator/training_category/(:num)'] = "backend/training_category_controller/index/$1";
$route['administrator/training_category/new'] = "backend/training_category_controller/create";
$route['administrator/training_category/edit/(:num)'] = "backend/training_category_controller/modify/$1";
$route['administrator/training_category/delete/(:num)'] = "backend/training_category_controller/remove/$1";

$route['administrator/training'] = "backend/training_controller";
$route['administrator/training/(:num)'] = "backend/training_controller/index/$1";
$route['administrator/training/new'] = "backend/training_controller/create";
$route['administrator/training/edit/(:num)'] = "backend/training_controller/modify/$1";
$route['administrator/training/delete/(:num)'] = "backend/training_controller/remove/$1";

$route['administrator/client'] = "backend/client_controller";
$route['administrator/client/(:num)'] = "backend/client_controller/index/$1";
$route['administrator/client/new'] = "backend/client_controller/create";
$route['administrator/client/edit/(:num)'] = "backend/client_controller/modify/$1";
$route['administrator/client/delete/(:num)'] = "backend/client_controller/remove/$1";

$route['administrator/sliders'] = "backend/sliders_controller";
$route['administrator/sliders/(:num)'] = "backend/sliders_controller/index/$1";
$route['administrator/sliders/new'] = "backend/sliders_controller/create";
$route['administrator/sliders/edit/(:num)'] = "backend/sliders_controller/modify/$1";
$route['administrator/sliders/delete/(:num)'] = "backend/sliders_controller/remove/$1";

$route['404_override'] = '';


/* End of file routes.php */
/* Location: ./application/config/routes.php */