<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
  
class product_category_model extends CI_Model {
 
    function __construct() {
        parent::__construct();
        $this->load->database();
    }
 
    function find($where='', $limit='10', $offset='', $q='') {
         $this->db->select('a.*,b.title as parent');
        $this->db->from('product_category a');
        $this->db->join('product_category b', 'a.parent_id = b.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('product_category');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword['a.'.$field] = $q;
            }
            $keyword['b.title'] = $q;
            $this->db->or_like($keyword);
        }
        $order = 'a.id asc';
        $this->db->order_by($order);
      
        if(!empty($offset) && !empty($limit)){
            $this->db->limit($limit, $offset);
        }
        elseif(!empty($limit)){
            $this->db->limit($limit);
        }
        $query =  $this->db-> get();
        
        return $query;
    }
    
    function findAll($where='') {
        $this->db->select('a.*,b.title as parent');
        $this->db->from('product_category a');
        $this->db->join('product_category b', 'a.parent_id = b.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        
        $order = 'a.id asc';
        $this->db->order_by($order);
        
        $query =  $this->db-> get();
        
        return $query;
    }
    
    public function add($data)
    {		
            $result = $this->db->insert('product_category', $data); 
            return $result;
    }
    
    public function edit($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('product_category', $data); 

            return $result;
    }
    
    public function replace($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('product_category', $data); 
            return $result;
    }
    
    public function delete($where)
    {		
            $this->db->where($where);
            $result = $this->db->delete('product_category'); 
            
            return $result;
    }
    
    public function getTotalRows($where='', $limit='10', $offset='', $q=''){
        $this->db->from('product_category');
        $this->db->join('product_category', 'product_category.parent_id = product_category.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('product_category');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword[$field] = $q;
            }
            $this->db->or_like($keyword);
        }
        $order = 'product_category.id asc';
        $this->db->order_by($order);
        
        $query =  $this->db -> get()->num_rows();
        
        return $query;
    }
    
    public function affectedRows(){
        return $this->db->affected_rows();
    }
    
    public function getErrorMessage(){
        return $this->db->_error_message();
    }
}