<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
  
class consulting_service_category_model extends CI_Model {
 
    function __construct() {
        parent::__construct();
        $this->load->database();
    }
 
    function find($where='', $limit='10', $offset='', $q='') {
         $this->db->select('a.*,b.title as parent');
        $this->db->from('consulting_service_category a');
        $this->db->join('consulting_service_category b', 'a.parent_id = b.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('consulting_service_category');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword['a.'.$field] = $q;
            }
            $keyword['b.title'] = $q;
            $this->db->or_like($keyword);
        }
        $order = 'a.id asc';
        $this->db->order_by($order);
      
        if(!empty($offset) && !empty($limit)){
            $this->db->limit($limit, $offset);
        }
        elseif(!empty($limit)){
            $this->db->limit($limit);
        }
        $query =  $this->db-> get();
        
//        print_r($query->result());die;
        return $query;
    }
    
    function findAll($where='') {
         $this->db->select('a.*,b.title as parent');
        $this->db->from('consulting_service_category a');
        $this->db->join('consulting_service_category b', 'a.parent_id = b.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        
        $order = 'a.id asc';
        $this->db->order_by($order);
      
        $query =  $this->db-> get();
        
//        print_r($query->result());die;
        return $query;
    }
    
    public function add($data)
    {		
            $result = $this->db->insert('consulting_service_category', $data); 
            return $result;
    }
    
    public function edit($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('consulting_service_category', $data); 

            return $result;
    }
    
    public function replace($where, $data)
    {
            $this->db->where($where);

            $result = $this->db->update('consulting_service_category', $data); 
            return $result;
    }
    
    public function delete($where)
    {		
            $this->db->where($where);
            $result = $this->db->delete('consulting_service_category'); 
            
            return $result;
    }
    
    public function getTotalRows($where='', $limit='10', $offset='', $q=''){
        $this->db->from('consulting_service_category');
        $this->db->join('consulting_service_category', 'consulting_service_category.parent_id = consulting_service_category.id', 'left');
        if(!empty($where)){
            $this->db->where($where);
        }
        if(!empty($q)){
            $fields = $this->db->list_fields('consulting_service_category');
            $keyword = array();
            foreach ($fields as $field)
            {
               $keyword[$field] = $q;
            }
            $this->db->or_like($keyword);
        }
        $order = 'consulting_service_category.id asc';
        $this->db->order_by($order);
        
        $query =  $this->db -> get()->num_rows();
        
        return $query;
    }
    
    public function affectedRows(){
        return $this->db->affected_rows();
    }
    
    public function getErrorMessage(){
        return $this->db->_error_message();
    }
}