<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class index_controller extends CI_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->helper(array('form', 'url', 'html'));
        $this->load->model('frontend/product_model');
        $this->load->model('frontend/product_category_model');
        $this->load->model('frontend/software_model');
        $this->load->model('frontend/software_category_model');
        $this->load->model('frontend/consulting_service_category_model');
        $this->load->model('frontend/consulting_service_model');
        $this->load->model('frontend/training_category_model');
        $this->load->model('frontend/training_model');
        $this->load->model('frontend/contacts_model');
        $this->load->model('frontend/about_model');
        $this->load->model('frontend/client_model');
        $this->load->model('frontend/news_category_model');
        $this->load->model('frontend/news_model');
        $this->load->helper(array('form','url'));
        $this->load->helper('captcha');
        $this->load->library(array('form_validation','session'));
        $this->load->library("pagination");
        $this->load->library('email');
    }

    public function index()
    {
        $data = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->find($where, $limit='10', $offset='', $q='');
        $data['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->find($where, $limit='10', $offset='', $q='');
        $data['product_category'] = $query->result();

        $where = array('news.status'=>'1');
        $query = $this->news_model->find($where, $limit='', $offset='', $q='', $order_by='id DESC');
        $data['news'] = $query->result();
        // var_dump($data['news']);

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/caroussel');
        $this->load->view('frontend/home',$data);
        $this->load->view('frontend/footer');

    }

    function about(){
        $data = array();
        $where = array('id'=>'1');
        $query = $this->about_model->find($where, $limit='10', $offset='', $q='');
        $data['about'] = $query->result()[0];

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/about',$data);
        $this->load->view('frontend/footer');
    }

    function history(){
        $data = array();
        $where = array('id'=>'1');
        $query = $this->about_model->find($where, $limit='10', $offset='', $q='');
        $data['about'] = $query->result()[0];

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/history',$data);
        $this->load->view('frontend/footer');
    }

    function software_products(){
        $data = array();
        $where = array('a.depth'=>'0','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['software_category'] = $query->result();

        foreach($data['software_category'] as $key=>$value){
            $where = array('a.depth'=>'1','a.status'=>'1','a.parent_id'=>$value->id);
            $query = $this->software_category_model->findAll($where);
            $result = $query->result();
            $value->child = $result;
        }

        $where = array('a.depth'=>'0','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['product_category'] = $query->result();

        foreach($data['product_category'] as $key=>$value){
            $where = array('a.depth'=>'1','a.status'=>'1','a.parent_id'=>$value->id);
            $query = $this->product_category_model->findAll($where);
            $result = $query->result();
            $value->child = $result;
        }

        $where = array('software.status'=>'1');
        $query = $this->software_model->find($where, $limit='', $offset='', $q='');
        $result = $query->result();
        $data['software'] = $result;
        //  var_dump($data['software']);
        $where = array('product.status'=>'1');
        $query = $this->product_model->find($where, $limit='', $offset='', $q='');
        $result = $query->result();
        $data['products'] = $result;
         // var_dump($data['products']);
        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/software_products',$data);
        $this->load->view('frontend/footer');
    }

    function software($id){

        $data = array();
        $where = array('a.status'=>'1','a.id'=>$id);
        $query = $this->software_category_model->findAll($where);
        $data['software_category'] = $query->result();

        if(!empty($data['software_category'])){
            foreach($data['software_category'] as $key=>$value){
                $where = array('a.status'=>'1','a.parent_id'=>$value->id);
                $query = $this->software_category_model->findAll($where);
                $result = $query->result();
                if($result){
                    $value->child = $result;
                    foreach($value->child as $k=>$v){
                        $where = array('software.status'=>'1','software.software_category_id'=>$v->id);
                        $query = $this->software_model->find($where, $limit='', $offset='', $q='');
                        $result = $query->result();
                        $v->software = $result;
                    }
                }
                else{
                    $where = array('software.status'=>'1','software.software_category_id'=>$value->id);
                    $query = $this->software_model->find($where, $limit='', $offset='', $q='');
                    $result = $query->result();
                    $value->software = $result;
                }
            }
        }
        else{
            $where = array('software.status'=>'1','software.software_category_id'=>$id);
            $query = $this->software_model->find($where, $limit='', $offset='', $q='');
            $result = $query->result();
            $data['software'] = $result;
        }

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/software',$data);
        $this->load->view('frontend/footer');
    }

    function products($id){
        $data = array();
        $where = array('a.status'=>'1','a.id'=>$id);
        $query = $this->product_category_model->findAll($where);
        $data['product_category'] = $query->result();

        if(!empty($data['product_category'])){
            foreach($data['product_category'] as $key=>$value){
                $where = array('a.status'=>'1','a.parent_id'=>$value->id);
                $query = $this->product_category_model->findAll($where);
                $result = $query->result();
                if($result){
                    $value->child = $result;
                    foreach($value->child as $k=>$v){
                        $where = array('product.status'=>'1','product.product_category_id'=>$v->id);
                        $query = $this->product_model->find($where, $limit='', $offset='', $q='');
                        $result = $query->result();
                        $v->products = $result;
                    }
                }
                else{
                    $where = array('product.status'=>'1','product.product_category_id'=>$value->id);
                    $query = $this->product_model->find($where, $limit='', $offset='', $q='');
                    $result = $query->result();
                    $value->products = $result;
                }
            }
        }
        else{
            $where = array('product.status'=>'1','product.product_category_id'=>$id);
            $query = $this->product_model->find($where, $limit='', $offset='', $q='');
            $result = $query->result();
            $data['products'] = $result;
        }

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/products',$data);
        $this->load->view('frontend/footer');
    }

    function consulting_service(){

        $data = array();
        $where = array('a.depth'=>'0','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['consulting_service'] = $query->result();

        foreach($data['consulting_service'] as $key=>$value){
            $where = array('a.depth'=>'1','a.status'=>'1','a.parent_id'=>$value->id);
            $query = $this->consulting_service_category_model->findAll($where);
            $result = $query->result();
            if($result){
                $value->child = $result;
                foreach($value->child as $k=>$v){
                    $where = array('consulting_service.status'=>'1','consulting_service.consulting_service_category_id'=>$v->id);
                    $query = $this->consulting_service_model->findAll($where);
                    $result = $query->result();
                    $v->products = $result;
                }
            }
            else{
                $where = array('consulting_service.status'=>'1','consulting_service.consulting_service_category_id'=>$value->id);
                $query = $this->consulting_service_model->findAll($where);
                $result = $query->result();
                $v->products = $result;
            }
        }

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/consulting_service',$data);
        $this->load->view('frontend/footer');
    }

    function training(){

        $data = array();
        $where = array('a.depth'=>'0','a.status'=>'1');
        $query = $this->training_category_model->findAll($where);
        $data['training'] = $query->result();

        foreach($data['training'] as $key=>$value){
            $where = array('a.depth'=>'1','a.status'=>'1','a.parent_id'=>$value->id);
            $query = $this->training_category_model->findAll($where);
            $result = $query->result();
            if($result){
                $value->child = $result;
                foreach($value->child as $k=>$v){
                    $where = array('training.status'=>'1','training.training_category_id'=>$v->id);
                    $query = $this->training_model->findAll($where);
                    $result = $query->result();
                    $v->products = $result;
                }
            }
            else{
                $where = array('training.status'=>'1','training.training_category_id'=>$value->id);
                $query = $this->training_model->findAll($where);
                $result = $query->result();
                $value->products = $result;
            }
        }

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/training',$data);
        $this->load->view('frontend/footer');
    }

    function news(){
        // if(empty($page)){
        //     $page = '1';
        // }
        $data = array();
        $q = "";
        $page_limit = '10';
        $where = array();
        $where['news_category.id'] = $category;
        $where['news.status'] = '1';
        $query = $this->news_model->find($where, $limit="", $offset="", $q);

        $config['base_url'] = base_url().'/news/';
        $config["uri_segment"] = 4;  // uri parameter
        $config['total_rows'] = $query->num_rows;
        $config['per_page'] = $page_limit;
        $config['use_page_numbers']  = TRUE;
        $config['first_tag_open'] = $config['last_tag_open']= $config['next_tag_open']= $config['prev_tag_open'] = $config['num_tag_open'] = '<li>';
        $config['first_tag_close'] = $config['last_tag_close']= $config['next_tag_close']= $config['prev_tag_close'] = $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='active'><span>";
        $config['cur_tag_close'] = "</span></li>";
        $this->pagination->initialize($config);
        $data['page'] = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data['paging'] = $this->pagination->create_links();

        if($page){
            $offset = ($page-1) * $page_limit;
        }
        else{
            $offset = 0;
        }

        $query = $this->news_model->find($where, $limit="10", $offset, $q);
        if($query->num_rows() > 0){
            $data['news'] = $query->result();
        }
        else{
            $data['news'] = "";
        }

        $where = array();
        $where['id'] = $category;
        $query = $this->news_category_model->find($where, $limit="", $offset="", $q);
        $data['category'] = $query->result()[0]->title;

        $where = array('news.status'=>'1');
        $query = $this->news_model->find($where, $limit='', $offset='', $q='');
        $result = $query->result();
        $data['newsnews'] = $result;

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/news',$data);
        $this->load->view('frontend/footer');
    }

    function news_view($category, $id){
        if(empty($id)){
            site_url(array(base_url(), 'news', $category, 'list'));
        }

        $where = array();
        $where['news.id'] = $id;
        $query = $this->news_model->find($where);
        $data['news'] = $query->result()[0];

        $where = array();
        $where['id'] = $category;
        $query = $this->news_category_model->find($where, $limit="", $offset="", $q);
        $data['category'] = $query->result()[0]->title;

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/news_view',$data);
        $this->load->view('frontend/footer');
    }

    function clients(){

        $data = array();

        $where = array();
        $where['id'] = '1';
        $result = $this->client_model->find($where)->result();
        $data['client'] = $result[0];

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/clients',$data);
        $this->load->view('frontend/footer');
    }

    function contacts(){

        $data = array();

        if($this->input->post()){
            $post = $this->input->post();
            foreach($post as $key => $value){
                if($key != "submit"){
                    $post_data[$key] = $value;
                }
            }

            $expiration = time()-7200; // Two hour limit
            $this->db->query("DELETE FROM captcha WHERE captcha_time < ".$expiration);

            // Then see if a captcha exists:
            $sql = "SELECT COUNT(*) AS count FROM captcha WHERE word = ? AND ip_address = ? AND captcha_time > ?";
            $binds = array($post_data['captcha'], $this->input->ip_address(), $expiration);
            $query = $this->db->query($sql, $binds);
            $row = $query->row();

            if ($row->count == 0)
            {
                $data['message'] = "<div class='col-md-12 alert alert-danger'><p>You must submit the word that appears in the image</p></div>";
            }
            else{

                $config['protocol'] = "smtp";
                $config['smtp_host'] = 'mail.atsindo.com';
                $config['smtp_port'] = '25';
                $config['smtp_user'] = 'noreply@atsindo.com';
                $config['smtp_pass'] = 'abcd1234';
                $config['charset'] = "utf-8";
                $config['mailtype'] = "html";
                $config['newline'] = "\r\n";

                $this->email->initialize($config);
                $this->email->clear();
                $this->email->from('noreply@atsindo.com', 'No Reply');
                $this->email->to('info@atsindo.com');
                $this->email->subject('New Contact Us Message');
                $this->email->message('Dear Customer Service,\r\n\r\n'.'new message from our valueable clients:\r\n\r\n'.'Name:'.$post_data['name'].'\r\n'.'Address:'.$post_data['address'].'\r\n'.'Phone No:'.$post_data['phone']." ext : ".$post_data['ext_phone'].'\r\n'.'Mobile Phone No:'.$post_data['mobile'].'\r\n'.'Email:'.$post_data['email'].'\r\n'.'Company:'.$post_data['company'].'\r\n'.'Division:'.$post_data['division'].'\r\n'.'Subject:'.$post_data['subject'].'\r\n'.'Messages:'.$post_data['message'].'\r\n'.'Please follow up our customer\'s message.'.'\r\n'.'\r\n'.'please do not reply this email, this email is generated automatically by our system.'.'Thank you,'.'\r\n\r\n'.'Regards,'.'\r\n\r\n\r\n No Reply');
                if ( ! $this->email->send())
                {
                    $contacts['message'] = "<div class='col-md-12 alert alert-danger'><p>Email was not sent</p></div>";
                }
                else{
                    $contacts['message'] = "<div class='col-md-12 alert alert-success'>
                                <p>Thank you for your messages, our customer service will keep in touch with you shortly.</p>
                            </div>";
                }
            }
        }

        $vals = array(
            'word'	=> '',
            'img_path'	=> 'assets/img/captcha/',
            'img_url'	=> base_url().'assets/img/captcha/',
            'font_path'	=> 'assets/fonts/texb.ttf',
            'img_width'	=> '150',
            'img_height' => 30,
            'expiration' => 7200
        );

        $cap = create_captcha($vals);

        $data = array(
            'captcha_time' => $cap['time'],
            'ip_address' => $this->input->ip_address(),
            'word' => $cap['word']
            );

        $query = $this->db->insert_string('captcha', $data);
        $this->db->query($query);

        $data['captcha'] = $cap;

        //footer
        $data['contacts'] = array();
        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->software_category_model->findAll($where);
        $data['contacts']['software_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->product_category_model->findAll($where);
        $data['contacts']['product_category'] = $query->result();

        $where = array('a.depth'=>'1','a.status'=>'1');
        $query = $this->consulting_service_category_model->findAll($where);
        $data['contacts']['consulting_service'] = $query->result();

        $where = array('id'=>'1');
        $query = $this->contacts_model->find($where);
        $data['contacts']['contacts'] = $query->result()[0];

        $data['subject'] = "";
        if(!empty($_GET['subject'])){
            $data['subject'] = $_GET['subject'];
        }

        $dump = array();
        $where = array('status'=>'1');
        $query = $this->news_category_model->findAll($where);
        $dump['news_category'] = $query->result();

        $this->load->view('frontend/header');
        $this->load->view('frontend/navigation',$dump);
        $this->load->view('frontend/contacts',$data);
        $this->load->view('frontend/footer');
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
