<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class product_category_controller extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('backend/product_category_model');
        $this->load->model('backend/product_model');
        $this->load->helper(array('form','url'));
        $this->load->library(array('form_validation','session'));
        $this->load->library("pagination");
    }
    
    function uploadFile($path, $file_type, $file_max_size, $overwrite, $file_max_width, $file_max_height, $file){
        
        $config['upload_path'] = $path;
        $config['allowed_types'] = $file_type;
        $config['max_size'] = $file_max_size;
        $config['overwrite'] = $overwrite;
        $config['max_width'] = $file_max_width;
        $config['max_height'] = $file_max_height;

        $this->load->library('upload', $config);
        if ( ! $this->upload->do_upload($file))
        {
            $result = array(false, $this->upload->display_errors());
            return $result;
        }
        else
        {
            $result = array(true, $this->upload->data());
            return $result;
        }
    }
 
    function index($page=""){
        if($this->session->userdata('logged_in'))
        {
            $q = "";
            if($this->input->post()){
                $post_data = $this->input->post();
                $q = $post_data['search'];
            }
            
            $page_limit = '20';
            
            $data['error'] = "";
            $where = array();
            $query = $this->product_category_model->find($where="", $limit="", $offset="", $q);
            $config['base_url'] = base_url().'/administrator/product_category/';
            $config['total_rows'] = $query->num_rows;
            $config['per_page'] = $page_limit; 
            $config['use_page_numbers']  = TRUE;
            $config['first_tag_open'] = $config['last_tag_open']= $config['next_tag_open']= $config['prev_tag_open'] = $config['num_tag_open'] = '<li>';
            $config['first_tag_close'] = $config['last_tag_close']= $config['next_tag_close']= $config['prev_tag_close'] = $config['num_tag_close'] = '</li>';
            $config['cur_tag_open'] = "<li class='active'><span>";
            $config['cur_tag_close'] = "</span></li>";
            $this->pagination->initialize($config); 

            $data['paging'] = $this->pagination->create_links();
            
            if($page){
                $offset = ($page-1) * $page_limit;
            }
            else{
                $offset = 0;
            }
            
            $query = $this->find($where="", $limit="20", $offset, $q);
            if($query->num_rows() > 0){
                $data['product_category'] = $query->result();
            }
            else{
                $data['product_category'] = "";
            }
            
            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/product_category', $data);
            $this->load->view('backend/footer');
            
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function create(){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            $data = array('id'=>'','title'=>'','image'=>'','summary'=>'','description'=>'','depth'=>'','parent_id'=>'','status'=>'1');
            
            $where = "";
            $where = array('a.status'=>'1');
            $query = $this->find($where, $limit="", $offset="", $q="");
            if($query->num_rows() > 0){
                $data['product_category'] = $query->result();
            }
            else{
                $data['product_category'] = "";
            }
            
            if($this->input->post()){
                if(!empty($_FILES['image']['name'])){
                    $upload = $this->uploadFile('assets/img/product_category/', 
                                                'gif|jpg|png', 
                                                '100000', 
                                                'false', 
                                                '1024', 
                                                '768', 
                                                'image');

                    if ($upload[0] == false)
                    {
                            $data['error'] = $upload[1];
                            $post = $this->input->post();
                            foreach($post as $key => $value){
                            if($key != "submit"){
                                $data[$key] = $value; 
                            }
                        }
                    }
                    elseif ($upload[0] == true)
                    {
                        $result = $upload[1];
                        
                        $post = $this->input->post();
                        $post_data = array();
                        foreach($post as $key => $value){
                            if($key != "submit" && $key!="image"){
                                $post_data[$key] = $value; 
                            }
                            elseif($key == 'image'){
                                $post_data['image'] = $value;
                            }
                        }
                        
                        $post_data['image'] = 'assets/img/product_category/'.$result['file_name'];
                        
                        $post_data['depth'] = 0;
                        if(!empty($post_data['parent_id'])){
                            $where = array();
                            $where['a.id'] = $post_data['parent_id'];
                            $parent_depth = $this->find($where)->result()[0];
                            $post_data['depth'] = $parent_depth->depth + 1;
                        }
                        
                        $result = "";
                        $result = $this->add($post_data);

                        if($result){
                            redirect('administrator/product_category', 'refresh');
                        }
                        else{
                            $data['error'] = $this->product_category_model->getErrorMessage();
                        }  
                    }
                }
                else{
                    
                    $post = $this->input->post();
                    $post_data = array();
                    $post_data2 = array();
                    foreach($post as $key => $value){
                        if($key != "submit" && $key != 'image'){
                            $post_data[$key] = $value; 
                        }
                        elseif($key == 'image'){
                            $post_data['image'] = '';
                        }
                    }
                    $result = $this->add($post_data);

                    if($result){
                        redirect('administrator/product_category', 'refresh');
                    }
                    else{
                        $data['error'] = $this->product_category_model->getErrorMessage();
                    }  
                    
                }
            }
            
            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/product_category_form',$data);
            $this->load->view('backend/footer');
        }
        else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function modify($id){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            
            if($this->input->post()){
                if(!empty($_FILES['image']['name'])){
                    $upload = $this->uploadFile('assets/img/product_category/', 
                                                'gif|jpg|png', 
                                                '100000', 
                                                'false', 
                                                '1024', 
                                                '768', 
                                                'image');

                    if ($upload[0] == false)
                    {
                            $data['error'] = $upload[1];
                            $post = $this->input->post();
                            foreach($post as $key => $value){
                            if($key != "submit"){
                                $data[$key] = $value; 
                            }
                        }
                    }
                    elseif ($upload[0] == true)
                    {
                        $result = $upload[1];
                        
                        $post = $this->input->post();
                        $post_data = array();
                        foreach($post as $key => $value){
                            if($key != "submit" && $key!="image"){
                                $post_data[$key] = $value; 
                            }
                            elseif($key == 'image'){
                                $post_data['image'] = $value;
                            }
                        }
                        
                        $post_data['image'] = 'assets/img/product_category/'.$result['file_name'];
                        
                        $post_data['depth'] = 0;
                        if(!empty($post_data['parent_id'])){
                            $where = array();
                            $where['a.id'] = $post_data['parent_id'];
                            $parent_depth = $this->find($where)->result()[0];
                            $post_data['depth'] = $parent_depth->depth + 1;
                        }
                        
                        
                        $where = array();
                        $where['id'] = $id;
                        
                        $result = "";
                        $result = $this->edit($where,$post_data);

                        if($result){
                            redirect('administrator/product_category', 'refresh');
                        }
                        else{
                            $data['error'] = $this->product_category_model->getErrorMessage();
                        }  
                    }
                }
                else{
                    
                    $where = array();
                    $where['id'] = $id;
                    $post = $this->input->post();
                    $post_data = array();
                    $post_data2 = array();
                    foreach($post as $key => $value){
                        if($key != "submit" && $key != 'image'){
                            $post_data[$key] = $value; 
                        }
                        elseif($key == 'image'){
                            $post_data['image'] = $value;
                        }
                    }
                    $result = $this->edit($where,$post_data);

                    if($result){
                        redirect('administrator/product_category', 'refresh');
                    }
                    else{
                        $data['error'] = $this->product_category_model->getErrorMessage();
                    }  
                    
                }
            }
            
            
            $where = "";
            $where['a.id'] = $id;
            $find = $this->product_category_model->find($where);
            $raw_data = $find->result();
            if($raw_data){
                foreach($raw_data as $key => $value){
                    foreach($value as $k => $v){
                        $data[$k] = $v;
                    }
                }
            }
            
            $where = "";
            $where = array('a.status'=>'1');
            $query = $this->find($where, $limit="", $offset="", $q="");
            if($query->num_rows() > 0){
                $data['product_category'] = $query->result();
            }
            else{
                $data['product_category'] = "";
            }
            

            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/product_category_form', $data);
            $this->load->view('backend/footer');
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function remove($id){
        if($this->session->userdata('logged_in'))
        {
            $data['success'] = "";
            $data['error'] = "";
            $where = array();
            $where['a.parent_id'] = $id;
            $where['a.status'] = '1';
            $query = $this->find($where, $limit='', $offset='', $q='');
            $existing = $query->num_rows();
            if($existing <= 0){
                $where = array();
                $where['product.product_category_id'] = $id;
                $where['product.status'] = '1';
                $query = $this->product_model->find($where, $limit='', $offset='', $q='');
                $parent = $query->num_rows();
                if($parent<=0){
                    $where = array();
                    $where['a.id'] = $id;

                    $search = $this->find($where);
                    if ($search->num_rows() > 0) {
                        $where = "";
                        $where['id'] = $id;
                        $remove = $this->delete($where);
                        if($remove){
                            redirect('administrator/product_category', 'refresh');
                        }
                        else{
                            echo "<script>alert('Unable to remove this category. Reason: ".$this->product_category_model->getErrorMessage()."');</script>";
                            redirect('administrator/consulting_service_category', 'refresh');
                        }
                    }
                    else{
                        echo "<script>alert('Unable to remove this category. Reason: ".$this->product_category_model->getErrorMessage()."');</script>";
                        redirect('administrator/product_category', 'refresh');
                    }
                }
                else{
                    echo "<script>alert('You cannot delete this category, because there are published item under this category.');</script>";
                    redirect('administrator/product_category', 'refresh');
                }
            }
            else{
                echo "<script>alert('You cannot delete this category, because there are active child category under this category.');</script>";
                redirect('administrator/product_category', 'refresh');
            }

            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/product_category', $data);
            $this->load->view('backend/footer');
        }else {
        //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    function find($where="", $limit="",$offset="", $q=""){
        $query = $this->product_category_model->find($where,$limit,$offset,$q);
        return $query;
    }
    
    function add($post_data){
        $query = $this->product_category_model->add($post_data);
        return $query;
    }
    
    function edit($where,$post_data){
        $query = $this->product_category_model->edit($where,$post_data);
        return $query;
    }
    
    function delete($where){
        $query = $this->product_category_model->delete($where);
        return $query;
    }
}