<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class home_controller extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('backend/login_model');
        $this->load->helper('url');
        $this->load->library(array('form_validation','session'));
    }
 
    function index() {
        if($this->session->userdata('logged_in'))
        {
            $session_data = $this->session->userdata('logged_in');
            $data['username'] = $session_data['username'];
            $data['id'] = $session_data['id'];
            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/home', $data);
            $this->load->view('backend/footer');
        } else {
        //If no session, redirect to login page
            redirect('/administrator/login', 'refresh');
        }
    }
 
    function logout() {
         //remove all session data
         $this->session->unset_userdata('logged_in');
         $this->session->sess_destroy();
         redirect('administrator/login', 'refresh');
     }
 
}