<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
session_start(); //we need to call PHP's session object to access it through CI
class about_controller extends CI_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->model('backend/about_model');
        $this->load->helper(array('form', 'url','html'));
        $this->load->library(array('form_validation','session'));
    }
    
    public function index()
    {
        if($this->session->userdata('logged_in'))
        {
            $about['error'] = '';
            $about['success'] = '';

            //update
            if($this->input->post()){
                $post = $this->input->post();
                foreach($post as $key => $value){
                    if($key != "submit"){
                        $post_data[$key] = $value; 
                    }
                }
                $where = array();
                $where['id'] = '1';
                $result = $this->about_model->edit($where,$post_data);

                if($result){
                    $about['success'] = 'The about us information successfully updated.';
                }
                else{
                    $about['error'] = $this->about_model->getErrorMessage();
                }  
            }

            $where = array();
            $where['id'] = '1';
            $result = $this->about_model->find($where)->result();
            $about['result'] = $result[0];



            $this->load->view('backend/header');
            $this->load->view('backend/navigation');
            $this->load->view('backend/about',$about);
            $this->load->view('backend/footer');
        }
        else{
            //If no session, redirect to login page
            redirect('administrator/login', 'refresh');
        }
    }
    
    
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */